/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;

public class ImpregnableModifier
extends Modifier
implements TooltipModifierHook,
BlockBreakModifierHook,
ToolDamageModifierHook,
ProjectileLaunchModifierHook,
ConditionalStatModifierHook {
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"impregnable.unbreaking");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.BLOCK_BREAK, ModifierHooks.TOOL_DAMAGE, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.PROJECTILE_LAUNCH});
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            LivingEntity living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(living) + 1);
            ((TinkerEffect)Utils.impregnableEffect.get()).apply(living, 160, effectLevel, true);
        }
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        float bonus = ImpregnableModifier.getBonus(holder, Utils.impregnableEffect, modifier.getLevel(), 6.0f);
        int off = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= 1.0f / bonus)) continue;
            ++off;
        }
        return amount - off;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(15, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.impregnableEffect.get()).apply(shooter, 100, effectLevel, true);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float bonus;
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && tooltipKey == TooltipKey.SHIFT && (bonus = ImpregnableModifier.getBonus((LivingEntity)player, Utils.impregnableEffect, modifier.getLevel(), 6.0f)) > 0.0f) {
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)UNBREAKING, (double)(1.0f / bonus), tooltip);
        }
    }
}

